<!DOCTYPE html>
<html>
<head>
    <title>Bookings Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Bookings Report</h1>
        <div class="filter-info">
            <strong>Time Filter:</strong> {{ ucfirst($timeFilter) }} |
            <strong>Status Filter:</strong> {{ $statusFilter === 'all' ? 'All Statuses' : ucfirst($statusFilter) }} |
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Invoice #</th>
                <th>Customer Name</th>
                <th>Car</th>
                <th>Roof Type</th>
                <th>Trailer Hitch</th>
                <th>Product</th>
                <th>Color</th>
                <th>Size/Variation</th>
                <th>Insured Included</th>
                <th>Carrier Length</th>
                <th>Foot SKU</th>
                <th>Foot Kit SKU</th>
                <th>Pickup Date/Time</th>
                <th>Dropoff Date/Time</th>
                <th>New Dropoff Date/Time</th>
                
               
            </tr>
        </thead>
        
        <tbody>
            @foreach($bookings as $booking)
                @foreach($booking->items as $item)
                @if(!$item->related_item)
                    <tr>
                        <td>#{{ $booking->id }}</td>
                        <td>{{ $booking->invoice_number ?? 'N/A' }}</td>
                        <td>{{ $booking->userDetails->first_name ?? '' }} {{ $booking->userDetails->last_name ?? '' }}</td>
                        <td>{{ $item->car_name }} {{ $item->car_year }} {{ $item->model }}</td>
                        <td>{{$item->roof_type}} </td>
                        <td>{{$item->trailer_hitch ? 'Yes' : 'No'}} </td>

                        <td>{{ $item->product_name }}</td>
                        <td>{{ $item->color }}</td>
                        <td>{{ $item->size }}</td>
                        <td>{{ $item->is_insured ? 'Yes' : 'No' }}</td>
                        <td>{{ $item->carrier_length }}</td>
                        <td>{{ $item->foot_sku }}</td>
                        <td>{{ $item->footkit_sku }}</td>
                        <td>
                            {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} -  {{ \Carbon\Carbon::parse($item->first()->pickup_time)->format('H:i') }}

                        </td>
                        
                        <td>
                            {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} -  {{ \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') }}

                        </td>
                        <td>
                            @if($item->new_dropoff_date)
                            {{ \Carbon\Carbon::parse($item->new_dropoff_date)->format('d.m.Y') }} -  {{ \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i') }}
                            @else
                                 N/A
                             @endif
                        </td>

                      
                       
                    </tr>
                    @endif
                @endforeach
            @endforeach

        </tbody>
    </table>
</body>
</html>
